<?php

namespace Omnipay\WechatPay;

class Helper
{
    public static function array2xml($arr, $root = 'xml')
    {
        $xml = "<{$root}>";
        foreach ($arr as $key => $val) {
            if (is_numeric($val)) {
                $xml .= '<' . $key . '>' . $val . '</' . $key . '>';
            } else {
                $xml .= '<' . $key . '><![CDATA[' . $val . ']]></' . $key . '>';
            }
        }
        $xml .= '</xml>';
        return $xml;
    }
    public static function xml2array($xml)
    {
        return json_decode(json_encode(simplexml_load_string($xml, 'SimpleXMLElement', LIBXML_NOCDATA)), true);
    }
    public static function sign($data, $key)
    {
        unset($data['sign']);
        ksort($data);
        $query = urldecode(http_build_query($data));
        $query .= "&key={$key}";
        return strtoupper(md5($query));
    }
}